/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class StorableInput {
    private StreamTokenizer fTokenizer;
    private Vector fMap;

    public StorableInput(InputStream stream) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, "UTF8"));
            this.fTokenizer = new StreamTokenizer(r);
            this.fMap = new Vector();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private Object makeInstance(String className) throws IOException {
        try {
            Class<?> cl = Class.forName(className);
            return cl.newInstance();
        }
        catch (NoSuchMethodError e) {
            throw new IOException("Class " + className + " does not seem to have a no-arg constructor");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("No class: " + className);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Class (" + className + ") not accessible");
        }
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    public boolean readBoolean() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return this.fTokenizer.nval;
        }
        String msg = "Double expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public int readInt() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public long readLong() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (long)this.fTokenizer.nval;
        }
        String msg = "Long expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public Storable readStorable() throws IOException {
        String s = this.readString();
        if (s.equals("NULL")) {
            return null;
        }
        if (s.equals("REF")) {
            int ref = this.readInt();
            return this.retrieve(ref);
        }
        Storable storable = (Storable)this.makeInstance(s);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public String readString() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -3 || token == 34) {
            if (this.fTokenizer.sval.equals("<$!null!$>")) {
                return null;
            }
            return this.fTokenizer.sval;
        }
        String msg = "String expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public Vector readVector() throws IOException {
        int size = this.readInt();
        Vector<Storable> vector = new Vector<Storable>(size);
        for (int i = 0; i < size; ++i) {
            vector.add(this.readStorable());
        }
        return vector;
    }

    private Storable retrieve(int ref) {
        return (Storable)this.fMap.elementAt(ref);
    }

    public Class readClass() throws IOException {
        try {
            return Class.forName(this.readString());
        }
        catch (ClassNotFoundException e) {
            String msg = "ClassNotFoundException " + e.getMessage() + " in line " + this.fTokenizer.lineno();
            throw new IOException(msg);
        }
        catch (IOException e) {
            throw e;
        }
    }
}

